#include        <stdlib.h>              /* malloc, NULL */
#include        <math.h>                /* fabs, sin, cos, atan, sqrt */

/*...........................................................................*/

/* Local defines. */

#define FLOATING        -1                      /* using floating type */
#define FRACTIONAL       1                      /* using fractional type */
#ifndef DATA_TYPE                       /* [ */
#define DATA_TYPE       FRACTIONAL              /* default */
#endif  /* ] */

/* Some constants. */
#ifndef PI                              /* [ */
#define PI 3.1415926535897931159979634685441851615905761718750 /* double */
#endif  /* ] */
#ifndef SIN_PI_Q                                /* [ */
#define SIN_PI_Q 0.7071067811865474617150084668537601828575134277343750
                                                /* sin(PI/4), (double) */
#endif  /* ] */
#ifndef INV_SQRT2                               /* [ */
#define INV_SQRT2 SIN_PI_Q                      /* 1/sqrt(2), (double) */
                                                /* 1/sqrt(2) = sin(PI/4) */
#endif  /* ] */

#define BART_0           2.0                    /* Bartlett 0th factor */

#define HANN_0           0.50                   /* Hanning 0th factor */
#define HANN_1          -0.50                   /* Hanning 1st factor */

#define HAMM_0           0.53836                /* Hamming 0th factor */
#define HAMM_1          -0.46164                /* Hamming 1st factor */

#define BLCK_0           0.42                   /* Blackman 0th factor */
#define BLCK_1          -0.50                   /* Blackman 1st factor */
#define BLCK_2           0.08                   /* Blackman 2nd factor */

#define COEFFS_IN_DATA  0xFF00                  /* page number used for */
                                                /* filter coefficients */
                                                /* when allocated in X */
                                                /* data memory */
/*...........................................................................*/

/* Local types. */

/* Type definitions. */
#ifndef fractional                      /* [ */

#if     DATA_TYPE==FLOATING             /* [ */
typedef double          fractional;
#else   /* ] */
typedef signed short    fractional;
#endif  /* ] */

#ifndef fractcomplex                    /* [ */
typedef struct {
  fractional real;
  fractional imag;
} fractcomplex;
#endif  /* ] fractcomplex */

#endif  /* ] fractional */

/* Generic function prototypes. */
#define Q15(X) \
   ((X < 0.0) ? (int)(32768*(X) - 0.5) : (int)(32767*(X) + 0.5))

#if     DATA_TYPE==FLOATING             /* [ */
#define Float2Fract(aVal)       (aVal)  /* Identity function */
#define Fract2Float(aVal)       (aVal)  /* Identity function */
#else   /* ] */
extern fractional Float2Fract (         /* Converts float into fractional */
   float aVal                           /* float value in range [-1, 1) */
);
extern float Fract2Float (        /* Converts fractional into float */
   fractional aVal         /* fract value in range {-1, 1-2^-15} */
);
#endif  /* ] */
